/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.tk.Toolkit;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.SecondaryLoop;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.CachingTransferable;
import javafx.embed.swing.SwingDnD;
import javafx.embed.swing.SwingEvents;
import javafx.embed.swing.SwingFXUtils;
import javafx.embed.swing.SwingNode;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import sun.awt.AWTAccessor;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.swing.JLightweightFrame;

final class FXDnD {
    private final SwingNode node;
    private static boolean fxAppThreadIsDispatchThread;
    private boolean isDragSourceListenerInstalled = false;
    private javafx.scene.input.MouseEvent pressEvent = null;
    private long pressTime = 0L;
    private volatile SecondaryLoop loop;
    private final Map<Component, FXDragGestureRecognizer> recognizers = new HashMap<Component, FXDragGestureRecognizer>();
    private final EventHandler<javafx.scene.input.MouseEvent> onMousePressHandler = event -> {
        this.pressEvent = event;
        this.pressTime = System.currentTimeMillis();
    };
    private volatile FXDragSourceContextPeer activeDSContextPeer;
    private final EventHandler<javafx.scene.input.MouseEvent> onDragStartHandler = event -> {
        this.activeDSContextPeer = null;
        javafx.scene.input.MouseEvent firstEv = this.getInitialGestureEvent();
        SwingFXUtils.runOnEDTAndWait(this, () -> this.fireEvent((int)firstEv.getX(), (int)firstEv.getY(), this.pressTime, SwingEvents.fxMouseModsToMouseMods(firstEv)));
        if (this.activeDSContextPeer == null) {
            return;
        }
        event.consume();
        Dragboard db = this.getNode().startDragAndDrop(SwingDnD.dropActionsToTransferModes(this.activeDSContextPeer.sourceActions).toArray(new TransferMode[1]));
        HashMap<DataFormat, Object> fxData = new HashMap<DataFormat, Object>();
        for (String mt : this.activeDSContextPeer.transferable.getMimeTypes()) {
            DataFormat f = DataFormat.lookupMimeType(mt);
            if (f == null) continue;
            fxData.put(f, this.activeDSContextPeer.transferable.getData(mt));
        }
        boolean hasContent = db.setContent(fxData);
        if (!hasContent && !fxAppThreadIsDispatchThread) {
            this.loop.exit();
        }
    };
    private final EventHandler<DragEvent> onDragDoneHandler = event -> {
        event.consume();
        if (!fxAppThreadIsDispatchThread) {
            this.loop.exit();
        }
        if (this.activeDSContextPeer != null) {
            TransferMode mode = event.getTransferMode();
            this.activeDSContextPeer.dragDone(mode == null ? 0 : SwingDnD.transferModeToDropAction(mode), (int)event.getX(), (int)event.getY());
        }
    };
    private boolean isDropTargetListenerInstalled = false;
    private volatile FXDropTargetContextPeer activeDTContextPeer = null;
    private final Map<Component, DropTarget> dropTargets = new HashMap<Component, DropTarget>();
    private final EventHandler<DragEvent> onDragEnteredHandler = event -> {
        int action;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer();
        }
        if ((action = this.activeDTContextPeer.postDropTargetEvent(event)) != 0) {
            event.consume();
        }
    };
    private final EventHandler<DragEvent> onDragExitedHandler = event -> {
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer();
        }
        this.activeDTContextPeer.postDropTargetEvent(event);
        this.activeDTContextPeer = null;
    };
    private final EventHandler<DragEvent> onDragOverHandler = event -> {
        int action;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer();
        }
        if ((action = this.activeDTContextPeer.postDropTargetEvent(event)) != 0) {
            event.acceptTransferModes(SwingDnD.dropActionsToTransferModes(action).toArray(new TransferMode[1]));
            event.consume();
        }
    };
    private final EventHandler<DragEvent> onDragDroppedHandler = event -> {
        int action;
        if (this.activeDTContextPeer == null) {
            this.activeDTContextPeer = new FXDropTargetContextPeer();
        }
        if ((action = this.activeDTContextPeer.postDropTargetEvent(event)) != 0) {
            event.setDropCompleted(this.activeDTContextPeer.success);
            event.consume();
        }
        this.activeDTContextPeer = null;
    };

    private SwingNode getNode() {
        return this.node;
    }

    FXDnD(SwingNode node) {
        this.node = node;
    }

    public <T> ComponentMapper<T> mapComponent(Map<Component, T> map, int x, int y) {
        return new ComponentMapper(map, x, y);
    }

    private void fireEvent(int x, int y, long evTime, int modifiers) {
        ComponentMapper<FXDragGestureRecognizer> mapper = this.mapComponent(this.recognizers, x, y);
        FXDragGestureRecognizer r = (FXDragGestureRecognizer)((ComponentMapper)mapper).object;
        if (r != null) {
            r.fireEvent(((ComponentMapper)mapper).x, ((ComponentMapper)mapper).y, evTime, modifiers);
        } else {
            SwingFXUtils.leaveFXNestedLoop(this);
        }
    }

    private javafx.scene.input.MouseEvent getInitialGestureEvent() {
        return this.pressEvent;
    }

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> abstractRecognizerClass, DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
        return (T)new FXDragGestureRecognizer(ds, c, srcActions, dgl);
    }

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        return new FXDragSourceContextPeer(dge);
    }

    public void addDropTarget(DropTarget dt) {
        this.dropTargets.put(dt.getComponent(), dt);
        Platform.runLater(() -> {
            if (!this.isDropTargetListenerInstalled) {
                this.node.addEventHandler(DragEvent.DRAG_ENTERED, this.onDragEnteredHandler);
                this.node.addEventHandler(DragEvent.DRAG_EXITED, this.onDragExitedHandler);
                this.node.addEventHandler(DragEvent.DRAG_OVER, this.onDragOverHandler);
                this.node.addEventHandler(DragEvent.DRAG_DROPPED, this.onDragDroppedHandler);
                this.isDropTargetListenerInstalled = true;
            }
        });
    }

    public void removeDropTarget(DropTarget dt) {
        this.dropTargets.remove(dt.getComponent());
        Platform.runLater(() -> {
            if (this.isDropTargetListenerInstalled && this.dropTargets.isEmpty()) {
                this.node.removeEventHandler(DragEvent.DRAG_ENTERED, this.onDragEnteredHandler);
                this.node.removeEventHandler(DragEvent.DRAG_EXITED, this.onDragExitedHandler);
                this.node.removeEventHandler(DragEvent.DRAG_OVER, this.onDragOverHandler);
                this.node.removeEventHandler(DragEvent.DRAG_DROPPED, this.onDragDroppedHandler);
                this.isDropTargetListenerInstalled = true;
            }
        });
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                fxAppThreadIsDispatchThread = "true".equals(System.getProperty("javafx.embed.singleThread"));
                return null;
            }
        });
    }

    private final class FXDropTargetContextPeer
    implements DropTargetContextPeer {
        private int targetActions = 0;
        private int currentAction = 0;
        private DropTarget dt = null;
        private DropTargetContext ctx = null;
        private final CachingTransferable transferable = new CachingTransferable();
        private boolean success = false;
        private int dropAction = 0;

        private FXDropTargetContextPeer() {
        }

        @Override
        public synchronized void setTargetActions(int actions) {
            this.targetActions = actions;
        }

        @Override
        public synchronized int getTargetActions() {
            return this.targetActions;
        }

        @Override
        public synchronized DropTarget getDropTarget() {
            return this.dt;
        }

        @Override
        public synchronized boolean isTransferableJVMLocal() {
            return false;
        }

        @Override
        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.transferable.getTransferDataFlavors();
        }

        @Override
        public synchronized Transferable getTransferable() {
            return this.transferable;
        }

        @Override
        public synchronized void acceptDrag(int dragAction) {
            this.currentAction = dragAction;
        }

        @Override
        public synchronized void rejectDrag() {
            this.currentAction = 0;
        }

        @Override
        public synchronized void acceptDrop(int dropAction) {
            this.dropAction = dropAction;
        }

        @Override
        public synchronized void rejectDrop() {
            this.dropAction = 0;
        }

        @Override
        public synchronized void dropComplete(boolean success) {
            this.success = success;
        }

        private int postDropTargetEvent(DragEvent event) {
            ComponentMapper mapper = FXDnD.this.mapComponent(FXDnD.this.dropTargets, (int)event.getX(), (int)event.getY());
            EventType<DragEvent> fxEvType = event.getEventType();
            Dragboard db = event.getDragboard();
            this.transferable.updateData(db, DragEvent.DRAG_DROPPED.equals(fxEvType));
            int sourceActions = SwingDnD.transferModesToDropActions(db.getTransferModes());
            int userAction = event.getTransferMode() == null ? 0 : SwingDnD.transferModeToDropAction(event.getTransferMode());
            DropTarget target = mapper.object != null ? (DropTarget)mapper.object : this.dt;
            SwingFXUtils.runOnEDTAndWait(FXDnD.this, () -> {
                if (target != this.dt) {
                    if (this.ctx != null) {
                        this.ctx.removeNotify();
                    }
                    this.ctx = null;
                    this.dropAction = 0;
                    this.currentAction = 0;
                }
                if (target != null) {
                    if (this.ctx == null) {
                        this.ctx = target.getDropTargetContext();
                        this.ctx.addNotify(this);
                    }
                    DropTarget dtl = target;
                    if (DragEvent.DRAG_DROPPED.equals(fxEvType)) {
                        DropTargetDropEvent awtEvent = new DropTargetDropEvent(this.ctx, new Point(mapper.x, mapper.y), userAction, sourceActions);
                        dtl.drop(awtEvent);
                    } else {
                        DropTargetDragEvent awtEvent = new DropTargetDragEvent(this.ctx, new Point(mapper.x, mapper.y), userAction, sourceActions);
                        if (DragEvent.DRAG_OVER.equals(fxEvType)) {
                            dtl.dragOver(awtEvent);
                        } else if (DragEvent.DRAG_ENTERED.equals(fxEvType)) {
                            dtl.dragEnter(awtEvent);
                        } else if (DragEvent.DRAG_EXITED.equals(fxEvType)) {
                            dtl.dragExit(awtEvent);
                        }
                    }
                }
                this.dt = (DropTarget)mapper.object;
                if (this.dt == null) {
                    if (this.ctx != null) {
                        this.ctx.removeNotify();
                    }
                    this.ctx = null;
                    this.dropAction = 0;
                    this.currentAction = 0;
                }
                if (DragEvent.DRAG_DROPPED.equals(fxEvType) || DragEvent.DRAG_EXITED.equals(fxEvType)) {
                    if (this.ctx != null) {
                        this.ctx.removeNotify();
                    }
                    this.ctx = null;
                }
                SwingFXUtils.leaveFXNestedLoop(FXDnD.this);
            });
            if (DragEvent.DRAG_DROPPED.equals(fxEvType)) {
                return this.dropAction;
            }
            return this.currentAction;
        }
    }

    private final class FXDragSourceContextPeer
    extends SunDragSourceContextPeer {
        private volatile int sourceActions;
        private final CachingTransferable transferable;

        @Override
        public void startSecondaryEventLoop() {
            Toolkit.getToolkit().enterNestedEventLoop(this);
        }

        @Override
        public void quitSecondaryEventLoop() {
            assert (!Platform.isFxApplicationThread());
            Platform.runLater(() -> Toolkit.getToolkit().exitNestedEventLoop(this, null));
        }

        @Override
        protected void setNativeCursor(long nativeCtxt, Cursor c, int cType) {
        }

        private void dragDone(int operation, int x, int y) {
            this.dragDropFinished(operation != 0, operation, x, y);
        }

        FXDragSourceContextPeer(DragGestureEvent dge) {
            super(dge);
            this.sourceActions = 0;
            this.transferable = new CachingTransferable();
        }

        protected void startDrag(Transferable trans, long[] formats, Map formatMap) {
            FXDnD.this.activeDSContextPeer = this;
            this.transferable.updateData(trans, true);
            this.sourceActions = this.getDragSourceContext().getSourceActions();
            if (!fxAppThreadIsDispatchThread) {
                FXDnD.this.loop = java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
                SwingFXUtils.leaveFXNestedLoop(FXDnD.this);
                if (!FXDnD.this.loop.enter()) {
                    // empty if block
                }
            }
        }
    }

    private class FXDragGestureRecognizer
    extends MouseDragGestureRecognizer {
        FXDragGestureRecognizer(DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
            super(ds, c, srcActions, dgl);
            if (c != null) {
                FXDnD.this.recognizers.put(c, this);
            }
        }

        @Override
        public void setComponent(Component c) {
            Component old = this.getComponent();
            if (old != null) {
                FXDnD.this.recognizers.remove(old);
            }
            super.setComponent(c);
            if (c != null) {
                FXDnD.this.recognizers.put(c, this);
            }
        }

        @Override
        protected void registerListeners() {
            SwingFXUtils.runOnFxThread(() -> {
                if (!FXDnD.this.isDragSourceListenerInstalled) {
                    FXDnD.this.node.addEventHandler(javafx.scene.input.MouseEvent.MOUSE_PRESSED, FXDnD.this.onMousePressHandler);
                    FXDnD.this.node.addEventHandler(javafx.scene.input.MouseEvent.DRAG_DETECTED, FXDnD.this.onDragStartHandler);
                    FXDnD.this.node.addEventHandler(DragEvent.DRAG_DONE, FXDnD.this.onDragDoneHandler);
                    FXDnD.this.isDragSourceListenerInstalled = true;
                }
            });
        }

        @Override
        protected void unregisterListeners() {
            SwingFXUtils.runOnFxThread(() -> {
                if (FXDnD.this.isDragSourceListenerInstalled) {
                    FXDnD.this.node.removeEventHandler(javafx.scene.input.MouseEvent.MOUSE_PRESSED, FXDnD.this.onMousePressHandler);
                    FXDnD.this.node.removeEventHandler(javafx.scene.input.MouseEvent.DRAG_DETECTED, FXDnD.this.onDragStartHandler);
                    FXDnD.this.node.removeEventHandler(DragEvent.DRAG_DONE, FXDnD.this.onDragDoneHandler);
                    FXDnD.this.isDragSourceListenerInstalled = false;
                }
            });
        }

        private void fireEvent(int x, int y, long evTime, int modifiers) {
            this.appendEvent(new MouseEvent(this.getComponent(), 501, evTime, modifiers, x, y, 0, false));
            int initialAction = SunDragSourceContextPeer.convertModifiersToDropAction(modifiers, this.getSourceActions());
            this.fireDragGestureRecognized(initialAction, new Point(x, y));
        }
    }

    private class ComponentMapper<T> {
        private int x;
        private int y;
        private T object = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ComponentMapper(Map<Component, T> map, int xArg, int yArg) {
            this.x = xArg;
            this.y = yArg;
            JLightweightFrame lwFrame = FXDnD.this.node.getLightweightFrame();
            Component c = AWTAccessor.getContainerAccessor().findComponentAt(lwFrame, this.x, this.y, false);
            if (c == null) {
                return;
            }
            Object object = c.getTreeLock();
            synchronized (object) {
                do {
                    this.object = map.get(c);
                } while (this.object == null && (c = c.getParent()) != null);
                if (this.object != null) {
                    while (c != lwFrame && c != null) {
                        this.x -= c.getX();
                        this.y -= c.getY();
                        c = c.getParent();
                    }
                }
            }
        }
    }
}

