/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.Graphics;
import com.sun.prism.Material;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DMesh;
import com.sun.prism.d3d.D3DPhongMaterial;
import com.sun.prism.impl.BaseMeshView;
import com.sun.prism.impl.Disposer;

class D3DMeshView
extends BaseMeshView {
    static int count = 0;
    private final D3DContext context;
    private final long nativeHandle;
    private final D3DMesh mesh;
    private D3DPhongMaterial material;

    private D3DMeshView(D3DContext context, long nativeHandle, D3DMesh mesh, Disposer.Record disposerRecord) {
        super(disposerRecord);
        this.context = context;
        this.mesh = mesh;
        this.nativeHandle = nativeHandle;
        ++count;
    }

    static D3DMeshView create(D3DContext context, D3DMesh mesh) {
        long nativeHandle = context.createD3DMeshView(mesh.getNativeHandle());
        return new D3DMeshView(context, nativeHandle, mesh, new D3DMeshViewDisposerRecord(context, nativeHandle));
    }

    @Override
    public void setCullingMode(int cullingMode) {
        this.context.setCullingMode(this.nativeHandle, cullingMode);
    }

    @Override
    public void setMaterial(Material material) {
        this.context.setMaterial(this.nativeHandle, ((D3DPhongMaterial)material).getNativeHandle());
        this.material = (D3DPhongMaterial)material;
    }

    @Override
    public void setWireframe(boolean wireframe) {
        this.context.setWireframe(this.nativeHandle, wireframe);
    }

    @Override
    public void setAmbientLight(float r, float g, float b) {
        this.context.setAmbientLight(this.nativeHandle, r, g, b);
    }

    @Override
    public void setPointLight(int index, float x, float y, float z, float r, float g, float b, float w) {
        if (index >= 0 && index <= 2) {
            this.context.setPointLight(this.nativeHandle, index, x, y, z, r, g, b, w);
        }
    }

    @Override
    public void render(Graphics g) {
        this.material.lockTextureMaps();
        this.context.renderMeshView(this.nativeHandle, g);
        this.material.unlockTextureMaps();
    }

    @Override
    public void dispose() {
        this.material = null;
        this.disposerRecord.dispose();
        --count;
    }

    public int getCount() {
        return count;
    }

    static class D3DMeshViewDisposerRecord
    implements Disposer.Record {
        private final D3DContext context;
        private long nativeHandle;

        D3DMeshViewDisposerRecord(D3DContext context, long nativeHandle) {
            this.context = context;
            this.nativeHandle = nativeHandle;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.nativeHandle != 0L) {
                this.traceDispose();
                this.context.releaseD3DMeshView(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        }
    }
}

