/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGShape;
import javafx.scene.shape.FillRule;

public class NGPath
extends NGShape {
    private Path2D p = new Path2D();

    public void reset() {
        this.p.reset();
    }

    public void update() {
        this.geometryChanged();
    }

    private int toWindingRule(FillRule rule) {
        if (rule == FillRule.NON_ZERO) {
            return 1;
        }
        return 0;
    }

    public void setFillRule(FillRule fillRule) {
        this.p.setWindingRule(this.toWindingRule(fillRule));
    }

    public float getCurrentX() {
        return this.p.getCurrentPoint().x;
    }

    public float getCurrentY() {
        return this.p.getCurrentPoint().y;
    }

    public void addClosePath() {
        this.p.closePath();
    }

    public void addMoveTo(float x, float y) {
        this.p.moveTo(x, y);
    }

    public void addLineTo(float x, float y) {
        this.p.lineTo(x, y);
    }

    public void addQuadTo(float ctrlx, float ctrly, float x, float y) {
        this.p.quadTo(ctrlx, ctrly, x, y);
    }

    public void addCubicTo(float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x, float y) {
        this.p.curveTo(ctrlx1, ctrly1, ctrlx2, ctrly2, x, y);
    }

    public void addArcTo(float arcX, float arcY, float arcW, float arcH, float arcStart, float arcExtent, float xAxisRotation) {
        Arc2D arc = new Arc2D(arcX, arcY, arcW, arcH, arcStart, arcExtent, 0);
        BaseTransform xform = (double)xAxisRotation == 0.0 ? null : BaseTransform.getRotateInstance(xAxisRotation, arc.getCenterX(), arc.getCenterY());
        PathIterator pi = arc.getPathIterator(xform);
        pi.next();
        this.p.append(pi, true);
    }

    public Path2D getGeometry() {
        return this.p;
    }

    @Override
    public Shape getShape() {
        return this.p;
    }

    public boolean acceptsPath2dOnUpdate() {
        return true;
    }

    public void updateWithPath2d(Path2D path) {
        this.p.setTo(path);
        this.geometryChanged();
    }
}

