/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.util.Arrays;

public class GrowableDataBuffer {
    static final int VAL_GROW_QUANTUM = 1024;
    static final int MAX_VAL_GROW = 0x100000;
    static final int MIN_OBJ_GROW = 32;
    static WeakLink buflist = new WeakLink();
    byte[] vals;
    int writevalpos;
    int readvalpos;
    int savevalpos;
    Object[] objs;
    int writeobjpos;
    int readobjpos;
    int saveobjpos;

    public static GrowableDataBuffer getBuffer(int minsize) {
        return GrowableDataBuffer.getBuffer(minsize, 32);
    }

    public static synchronized GrowableDataBuffer getBuffer(int minvals, int minobjs) {
        WeakLink prev = buflist;
        WeakLink cur = GrowableDataBuffer.buflist.next;
        while (cur != null) {
            GrowableDataBuffer curgdb = (GrowableDataBuffer)cur.bufref.get();
            WeakLink next = cur.next;
            if (curgdb == null) {
                prev.next = cur = next;
                continue;
            }
            if (curgdb.valueCapacity() >= minvals && curgdb.objectCapacity() >= minobjs) {
                prev.next = next;
                return curgdb;
            }
            prev = cur;
            cur = next;
        }
        return new GrowableDataBuffer(minvals, minobjs);
    }

    public static synchronized void returnBuffer(GrowableDataBuffer retgdb) {
        int retvlen = retgdb.valueCapacity();
        int retolen = retgdb.objectCapacity();
        retgdb.reset();
        WeakLink prev = buflist;
        WeakLink cur = GrowableDataBuffer.buflist.next;
        while (cur != null) {
            GrowableDataBuffer curgdb = (GrowableDataBuffer)cur.bufref.get();
            WeakLink next = cur.next;
            if (curgdb == null) {
                prev.next = cur = next;
                continue;
            }
            int curvlen = curgdb.valueCapacity();
            int curolen = curgdb.objectCapacity();
            if (curvlen > retvlen || curvlen == retvlen && curolen >= retolen) break;
            prev = cur;
            cur = next;
        }
        WeakLink retlink = new WeakLink();
        retlink.bufref = new WeakReference<GrowableDataBuffer>(retgdb);
        prev.next = retlink;
        retlink.next = cur;
    }

    private GrowableDataBuffer(int initvalsize, int initobjsize) {
        this.vals = new byte[initvalsize];
        this.objs = new Object[initobjsize];
    }

    public int readValuePosition() {
        return this.readvalpos;
    }

    public int writeValuePosition() {
        return this.writevalpos;
    }

    public int readObjectPosition() {
        return this.readobjpos;
    }

    public int writeObjectPosition() {
        return this.writeobjpos;
    }

    public int valueCapacity() {
        return this.vals.length;
    }

    public int objectCapacity() {
        return this.objs.length;
    }

    public void save() {
        this.savevalpos = this.readvalpos;
        this.saveobjpos = this.readobjpos;
    }

    public void restore() {
        this.readvalpos = this.savevalpos;
        this.readobjpos = this.saveobjpos;
    }

    public boolean hasValues() {
        return this.readvalpos < this.writevalpos;
    }

    public boolean hasObjects() {
        return this.readobjpos < this.writeobjpos;
    }

    public boolean isEmpty() {
        return this.writevalpos == 0;
    }

    public void reset() {
        this.writevalpos = 0;
        this.savevalpos = 0;
        this.readvalpos = 0;
        this.saveobjpos = 0;
        this.readobjpos = 0;
        if (this.writeobjpos > 0) {
            Arrays.fill(this.objs, 0, this.writeobjpos, null);
            this.writeobjpos = 0;
        }
    }

    public void append(GrowableDataBuffer gdb) {
        this.ensureWriteCapacity(gdb.writevalpos);
        System.arraycopy(gdb.vals, 0, this.vals, this.writevalpos, gdb.writevalpos);
        this.writevalpos += gdb.writevalpos;
        if (this.writeobjpos + gdb.writeobjpos > this.objs.length) {
            this.objs = Arrays.copyOf(this.objs, this.writeobjpos + gdb.writeobjpos);
        }
        System.arraycopy(gdb.objs, 0, this.objs, this.writeobjpos, gdb.writeobjpos);
        this.writeobjpos += gdb.writeobjpos;
    }

    private void ensureWriteCapacity(int newbytes) {
        if (newbytes > this.vals.length - this.writevalpos) {
            newbytes = this.writevalpos + newbytes - this.vals.length;
            int growbytes = Math.min(this.vals.length, 0x100000);
            if (growbytes < newbytes) {
                growbytes = newbytes;
            }
            int newsize = this.vals.length + growbytes;
            newsize = newsize + 1023 & 0xFFFFFC00;
            this.vals = Arrays.copyOf(this.vals, newsize);
        }
    }

    private void ensureReadCapacity(int bytesneeded) {
        if (this.readvalpos + bytesneeded > this.writevalpos) {
            throw new BufferOverflowException();
        }
    }

    public void putBoolean(boolean b) {
        this.putByte(b ? (byte)1 : 0);
    }

    public void putByte(byte b) {
        this.ensureWriteCapacity(1);
        this.vals[this.writevalpos++] = b;
    }

    public void putChar(char c) {
        this.ensureWriteCapacity(2);
        this.vals[this.writevalpos++] = (byte)(c >> 8);
        this.vals[this.writevalpos++] = (byte)c;
    }

    public void putShort(short s) {
        this.ensureWriteCapacity(2);
        this.vals[this.writevalpos++] = (byte)(s >> 8);
        this.vals[this.writevalpos++] = (byte)s;
    }

    public void putInt(int i) {
        this.ensureWriteCapacity(4);
        this.vals[this.writevalpos++] = (byte)(i >> 24);
        this.vals[this.writevalpos++] = (byte)(i >> 16);
        this.vals[this.writevalpos++] = (byte)(i >> 8);
        this.vals[this.writevalpos++] = (byte)i;
    }

    public void putLong(long l) {
        this.ensureWriteCapacity(8);
        this.vals[this.writevalpos++] = (byte)(l >> 56);
        this.vals[this.writevalpos++] = (byte)(l >> 48);
        this.vals[this.writevalpos++] = (byte)(l >> 40);
        this.vals[this.writevalpos++] = (byte)(l >> 32);
        this.vals[this.writevalpos++] = (byte)(l >> 24);
        this.vals[this.writevalpos++] = (byte)(l >> 16);
        this.vals[this.writevalpos++] = (byte)(l >> 8);
        this.vals[this.writevalpos++] = (byte)l;
    }

    public void putFloat(float f) {
        this.putInt(Float.floatToIntBits(f));
    }

    public void putDouble(double d) {
        this.putLong(Double.doubleToLongBits(d));
    }

    public void putObject(Object o) {
        if (this.writeobjpos >= this.objs.length) {
            this.objs = Arrays.copyOf(this.objs, this.writeobjpos + 32);
        }
        this.objs[this.writeobjpos++] = o;
    }

    public byte peekByte(int i) {
        if (i >= this.writevalpos) {
            throw new BufferOverflowException();
        }
        return this.vals[i];
    }

    public Object peekObject(int i) {
        if (i >= this.writeobjpos) {
            throw new BufferOverflowException();
        }
        return this.objs[i];
    }

    public boolean getBoolean() {
        this.ensureReadCapacity(1);
        return this.vals[this.readvalpos++] != 0;
    }

    public byte getByte() {
        this.ensureReadCapacity(1);
        return this.vals[this.readvalpos++];
    }

    public int getUByte() {
        this.ensureReadCapacity(1);
        return this.vals[this.readvalpos++] & 0xFF;
    }

    public char getChar() {
        this.ensureReadCapacity(2);
        int c = this.vals[this.readvalpos++];
        c = c << 8 | this.vals[this.readvalpos++] & 0xFF;
        return (char)c;
    }

    public short getShort() {
        this.ensureReadCapacity(2);
        int s = this.vals[this.readvalpos++];
        s = s << 8 | this.vals[this.readvalpos++] & 0xFF;
        return (short)s;
    }

    public int getInt() {
        this.ensureReadCapacity(4);
        int i = this.vals[this.readvalpos++];
        i = i << 8 | this.vals[this.readvalpos++] & 0xFF;
        i = i << 8 | this.vals[this.readvalpos++] & 0xFF;
        i = i << 8 | this.vals[this.readvalpos++] & 0xFF;
        return i;
    }

    public long getLong() {
        this.ensureReadCapacity(8);
        long l = this.vals[this.readvalpos++];
        l = l << 8 | (long)(this.vals[this.readvalpos++] & 0xFF);
        l = l << 8 | (long)(this.vals[this.readvalpos++] & 0xFF);
        l = l << 8 | (long)(this.vals[this.readvalpos++] & 0xFF);
        l = l << 8 | (long)(this.vals[this.readvalpos++] & 0xFF);
        l = l << 8 | (long)(this.vals[this.readvalpos++] & 0xFF);
        l = l << 8 | (long)(this.vals[this.readvalpos++] & 0xFF);
        l = l << 8 | (long)(this.vals[this.readvalpos++] & 0xFF);
        return l;
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public Object getObject() {
        if (this.readobjpos >= this.objs.length) {
            throw new BufferOverflowException();
        }
        return this.objs[this.readobjpos++];
    }

    static class WeakLink {
        WeakReference<GrowableDataBuffer> bufref;
        WeakLink next;

        WeakLink() {
        }
    }
}

